<?php
/* --------------------------------------------------------------
   LanguageInterface.php 2020-06-02
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Core\Language;

/**
 * Class LanguageInterface
 *
 * @package Gambio\Core\Language
 */
interface Language
{
    /**
     * Returns the ID of the language.
     *
     * @return int
     */
    public function id(): int;
    
    
    /**
     * Returns the two digit code of the language.
     *
     * @return string
     */
    public function code(): string;
    
    
    /**
     * Returns the name of the language.
     *
     * @return string
     */
    public function name(): string;
    
    
    /**
     * Returns the charset of the language.
     *
     * @return string
     */
    public function charset(): string;
    
    
    /**
     * Returns the directory of the language.
     *
     * @return string
     */
    public function directory(): string;
}